function [Postion_Err,File_N]=Position_Err15(NI_daq_session,core)

% The output of this function represents the degree of position uncertainty
% which is taken into the account every time the system measures the particle position.
% This value is considered to be a vibrational noise value for the particle position.

% The process starts by capturing 20 consecutive images of the levitated particle and recording
% the particle scattered position each time. Then these positions are saved into a coordinate 
% matrix system. Following this stage, 20 projected positions are generated on the straight path 
% between the first and the last particle positions. These projected positions (generated and plotted 
% by a MATLAB fixed scatter function), are equally separated by a drift distance incremental rate l,
% which is calculated by dividing the Cartesian distance between the first and last position by 
% the number of positions n. In order to obtain the vibration value, the Cartesian distance between  
% the real positions and the projected positions are calculated. Finally, the vibration value is 
% calculated and defined asPostion_Err. 

% At the end of each vibration measurement, the vibration value (Postion_Err) is an 
% important indication of the acoustofluidic device condition before starting the particle 
% manipulation step. Using this method the acceptable range is less than two pixels (1 m).

 


my_dir='F:\SteeringControl\Steer ('; % specify the steering file
% specify file number to save all data and images by pop up message
prompt = {'File_Number'};
dlg_title = 'File_Number';
File_N=str2double(inputdlg(prompt,dlg_title));


levitation_Freq(NI_daq_session,3);% avoid extra shift from single pzt activation ( both pzts provide more stability )
[X,Y]=Determine_Pts2(core);
x=[];y=[];x=[x X];y=[y Y];

for i=2:21
img=Snap_Image(core); % snap an image
[X,Y]=Find_Bead(img,10,X,Y);% find the particle.
x=[x X];y=[y Y];
end
levitation_Freq(NI_daq_session,3);% avoid extra shift from single pzt activation ( both pzts provide more stability )

x(1)=[];y(1)=[];% remove the first position because of long time to start the measurement.
grid on;hold on;
scatter(x,y,'r');set(gca,'YDir','reverse');% display all scattered positions
Pic=20;
% DRIFT=(FIRST POSITION-LAST POSITION)/NUMBER OF FRAMES
drift_x=(x(Pic)-x(1))/(Pic-1);drift_y=(y(Pic)-y(1))/(Pic-1);
Drift=sqrt(drift_x^2+drift_y^2);

VIB=[];% vibration matrix
[X_EXP, Y_EXP] =Fixed_Scatter([x(1) y(1)],[x(Pic) y(Pic)],Drift); % generate the projected positions

% draw lines between projected and scattered positions.
for i=1:Pic
[r]=drawLine([x(i) y(i)],[X_EXP(i) Y_EXP(i)]);
VIB=[VIB r];
end

Postion_Err=sqrt(sum(VIB.^2)/(Pic-1));% vibrational noise value 
scatter(x(Pic),y(Pic),'k');% display all scattered positions
% save figure as an image into a steering file
title(['position Error for run(' num2str(File_N) ') is  ' num2str(Postion_Err) '']);
saveas(gcf,[my_dir,num2str(File_N),')\Postion_Err=',num2str(Postion_Err),'.png']);
end




